% Parametri di sistema
p = 1; K = 1; qz = 1; zeta = 1;

% Parametro biforcazione
Sz = linspace(0, 3, 300);
z_star = Sz / qz;
u_nontrivial = K - (zeta * Sz) ./ (p * qz);
u_nontrivial(u_nontrivial < 0) = NaN;  % solo se biologicamente valido

% Soglia di biforcazione (punto critico)
Sz_crit = p * K * qz / zeta;

% Plot
figure;
plot(Sz, zeros(size(Sz)), 'k--', 'LineWidth', 2); hold on;
plot(Sz, u_nontrivial, 'b-', 'LineWidth', 2);
xline(Sz_crit, 'r:', ['S_z = ' num2str(Sz_crit)], 'LineWidth', 2);

xlabel('S_z (sorgente immunitaria)');
ylabel('Popolazione tumorale all''equilibrio u^*');
title('Diagramma biforcativo per il sistema senza infezione');
legend('u^* = 0 (triviale)', 'u^* non-triviale', 'Soglia di biforcazione');
grid on;
